

<?php $__env->startSection('title', $user->name . ' - Profile'); ?>

<?php $__env->startSection('content'); ?>
<div class="profile-container">
    <!-- Profile Banner -->
    <div class="profile-banner">
        <?php if($user->banner): ?>
            <img src="<?php echo e(Storage::url('user_banners/' . $user->banner)); ?>" alt="<?php echo e($user->name); ?>'s Banner" class="banner-image">
        <?php else: ?>
            <div class="default-banner-bg"></div>
        <?php endif; ?>
    </div>
    
    <div class="profile-header">
        <div class="profile-avatar">
            <img src="<?php echo e($user->avatar); ?>" alt="<?php echo e($user->name); ?>'s Avatar">
        </div>
        <div class="profile-info">
            <h1 class="profile-name"><?php echo e($user->name); ?></h1>
            
            <div class="profile-steam">
                <a href="<?php echo e($user->getSteamProfileUrl()); ?>" target="_blank" class="steam-link">
                    <i class="fab fa-steam"></i> Steam Profile
                </a>
            </div>
            
            <?php if(Auth::id() === $user->id): ?>
                <div class="profile-actions">
                    <a href="<?php echo e(route('profile.edit')); ?>" class="btn btn-primary">
                        <i class="fas fa-edit"></i> Edit Profile
                    </a>
                </div>
            <?php endif; ?>
        </div>
    </div>
    
    <!-- Stats Overview -->
    <div class="stats-row">
        <div class="stat-card">
            <div class="stat-icon">
                <i class="fas fa-calendar-alt"></i>
            </div>
            <div class="stat-value"><?php echo e($user->created_at->format('Y')); ?></div>
            <div class="stat-label">Member Since</div>
        </div>
        
        <div class="stat-card">
            <div class="stat-icon">
                <i class="fas fa-comment-alt"></i>
            </div>
            <div class="stat-value"><?php echo e($activities->count()); ?></div>
            <div class="stat-label">Activities</div>
        </div>
        
        <div class="stat-card">
            <div class="stat-icon">
                <i class="fas fa-trophy"></i>
            </div>
            <div class="stat-value"><?php echo e($achievements->count()); ?></div>
            <div class="stat-label">Achievements</div>
        </div>
    </div>
    
    <div class="profile-content">
        <!-- User Info Section -->
        <div class="profile-section">
            <h2 class="section-title">
                <i class="fas fa-user-circle"></i> User Info
            </h2>
            <div class="info-card">
                <div class="info-item">
                    <span class="info-label">Member since:</span>
                    <span class="info-value"><?php echo e($user->created_at->format('F j, Y')); ?></span>
                </div>
                <div class="info-item">
                    <span class="info-label">Steam ID:</span>
                    <span class="info-value"><?php echo e($user->steamid); ?></span>
                </div>
                
                <?php if($user->roles && $user->roles->count() > 0): ?>
                    <div class="info-item">
                        <span class="info-label">Roles:</span>
                        <div class="role-badges">
                            <?php $__currentLoopData = $user->roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <span class="role-badge"><?php echo e($role->name); ?></span>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        </div>
        
        <!-- Achievements Section -->
        <div class="profile-section achievements-section">
            <h2 class="section-title">
                <i class="fas fa-trophy"></i> Achievements
            </h2>
            <div class="info-card">
                <?php if($achievements && $achievements->count() > 0): ?>
                    <div class="all-achievements">
                        <h3 class="sub-section-title">All Achievements</h3>
                        <div class="achievements-grid">
                            <?php $__currentLoopData = $achievements; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $achievement): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php if($achievement->unlocked_at): ?>
                                    <div class="achievement-card">
                                        <div class="achievement-icon">
                                            <i class="fas <?php echo e($achievement->icon ?? 'fa-trophy'); ?>"></i>
                                        </div>
                                        <div class="achievement-info">
                                            <div class="achievement-name"><?php echo e($achievement->name); ?></div>
                                            <div class="achievement-description"><?php echo e($achievement->description); ?></div>
                                            <div class="achievement-unlocked">
                                                Unlocked <?php echo e($achievement->unlocked_at->diffForHumans()); ?>

                                            </div>
                                        </div>
                                    </div>
                                <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                <?php else: ?>
                    <div class="empty-achievements">
                        <div class="empty-icon">
                            <i class="fas fa-trophy"></i>
                        </div>
                        <h3 class="empty-title">No Achievements Yet</h3>
                        <p class="empty-description">
                            This user hasn't unlocked any achievements yet. Check back later!
                        </p>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
    
    <?php if(config_value('forum_allow_activities', true)): ?>
    <!-- Activity Section -->
    <div class="profile-section activity-section-small">
        <div class="activity-header">
            <h2 class="section-title">
                <i class="fas fa-history"></i> Recent Activity
            </h2>
        </div>
        
        <div class="info-card">
            <?php if($activities->count() > 0): ?>
                <div class="activity-timeline-small">
                    <?php $__currentLoopData = $activities->take(3); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $activity): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                            $activityData = json_decode($activity->activity_data);
                            $activityType = strtolower($activity->activity_type);
                            
                            // Determine icon based on activity type
                            $icon = 'fa-circle';
                            
                            if (strpos($activityType, 'replied') !== false) {
                                $icon = 'fa-reply';
                            } elseif (strpos($activityType, 'created thread') !== false) {
                                $icon = 'fa-plus-circle';
                            } elseif (strpos($activityType, 'joined server') !== false) {
                                $icon = 'fa-server';
                            } elseif (strpos($activityType, 'purchased') !== false) {
                                $icon = 'fa-shopping-cart';
                            } elseif (strpos($activityType, 'achievement') !== false) {
                                $icon = 'fa-trophy';
                            }
                            
                            // Determine content details
                            $detailText = '';
                            $linkUrl = '#';
                            $linkText = '';
                            
                            if (isset($activityData->thread_name)) {
                                $detailText = $activityData->thread_name;
                                if (isset($activityData->board_name)) {
                                    $detailText .= ' in ' . $activityData->board_name;
                                }
                                $linkText = 'View Thread';
                                $linkUrl = isset($activityData->thread_slug) ? 
                                    route('forum.thread', $activityData->thread_slug) : '#';
                            } elseif (isset($activityData->server_name)) {
                                $detailText = $activityData->server_name;
                                $linkText = '';
                                $linkUrl = '#';
                            } elseif (isset($activityData->item_name)) {
                                $detailText = $activityData->item_name;
                                $linkText = 'View Item';
                                $linkUrl = isset($activityData->item_id) ? 
                                    route('store.show', $activityData->item_id) : '#';
                            } elseif (isset($activityData->achievement_name)) {
                                $detailText = $activityData->achievement_name;
                                $linkText = '';
                                $linkUrl = '#';
                            }
                        ?>
                        
                        <div class="activity-item">
                            <div class="activity-dot"></div>
                            <div class="activity-card">
                                <div class="activity-header">
                                    <span class="activity-type">
                                        <i class="fas <?php echo e($icon); ?>"></i>
                                        <?php echo e(ucfirst(explode(' ', $activityType)[0])); ?>

                                    </span>
                                    <span class="activity-time"><?php echo e($activity->created_at->diffForHumans()); ?></span>
                                </div>
                                
                                <div class="activity-content">
                                    <div class="activity-title">
                                        <?php echo e($user->name); ?> <?php echo e($activity->activity_type); ?>

                                    </div>
                                    <div class="activity-details">
                                        <?php echo e($detailText ?: 'Activity details not available.'); ?>

                                    </div>
                                </div>
                                
                                <?php if($linkText): ?>
                                <!-- Maybe... I don't like it? I Think?
                                <div class="activity-footer">
                                    <a href="<?php echo e($linkUrl); ?>" class="activity-link">
                                        <?php echo e($linkText); ?> <i class="fas fa-arrow-right"></i>
                                    </a>
                                </div>
                                -->
                                <?php endif; ?>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
                
                <?php if($activities->hasPages()): ?>
                    <div class="pagination-container">
                        <?php echo e($activities->links()); ?>

                    </div>
                <?php endif; ?>
            <?php else: ?>
                <div class="empty-activity">
                    <div class="empty-icon">
                        <i class="fas fa-calendar-day"></i>
                    </div>
                    <h3 class="empty-title">No Activity Yet</h3>
                    <p class="empty-description">
                        This user hasn't recorded any activity yet. Check back later!
                    </p>
                </div>
            <?php endif; ?>
        </div>
    </div>
    <?php endif; ?>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/siedestudios.co.uk/edge/resources/views/users/profile.blade.php ENDPATH**/ ?>